# Impact Monitor Framework

This guide provides an overview of the **Impact Monitor Framework** data and associated tools, models, and workflows.


## 01. Documentation

- **MDPI Publication**  
  A conceptual and technical description of the Impact Monitor Framework.

- **Tool Integration Exercise**  
  Tutorial demonstrating how to connect a domain-specific tool and integrate it with CPACS.

- **Tool Wrapper**  
  Step-by-step guide for integrating a wrapper tool.


## 02. Data Model

- **cpacs_schema.xsd**  
  XML Schema Definition (XSD) describing the structure of the CPACS data model.

- **CPACS Documentation**  
  Comprehensive documentation detailing the Impact Monitor-specific extensions and use of the CPACS data model.


## 03. Tools

- **RCE**  
  Remote Component Environment to execute Impact Monitor studies

- **NextCloud Interface**  
  RCE-compatible interface to upload and download data to/from a NextCloud data repository.

- **RCE (Remote Computing Environment)**  
  Platform enabling remote execution of tools and workflows.


## 04. Workflows  

For each of the three analysis levels providing:

- **Workflow Concepts**  
  Description of analysis workflows using the interactive extended Design Structure Matrix along with input files for MDAx

- **RCE workflow files**  
  Input data for Remote Component Environemnt for execution of impact assessment studies
